% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bible.R
\name{get_bible_version}
\alias{get_bible_version}
\title{Get Bible Version}
\usage{
get_bible_version(language, testament)
}
\arguments{
\item{language}{A character string specifying the language of the Bible.
Must be one of \code{"English"}, \code{"Hebrew"}, or \code{"Greek"}.}

\item{testament}{A character string specifying the testament. This input is standardized using
\code{standardize_testament()} and should typically be \code{"Old Testament"}, \code{"New Testament"},
or \code{"Both"}.}
}
\value{
A data frame containing the Bible data corresponding to the selected language and testament.
}
\description{
Retrieves the Bible data filtered by the specified language and testament.
}
\details{
This function filters the underlying Bible dataset based on the specified \code{language} and \code{testament}.
For English, it divides the dataset into Old and New Testaments by using predefined book ranges from the
\code{rasb_bible} dataset. For Hebrew and Greek, it refers to the \code{old_testament} and \code{new_testament}
datasets respectively, and will produce an error if an unsupported combination is requested.
}
\keyword{internal}
