% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_error}
\alias{log_error}
\title{Logs an error}
\usage{
log_error(msg = NULL)
}
\arguments{
\item{msg}{The message to log.}
}
\description{
Writes an error message to the log. Error will be written
both to the log and the message file.  For the log, the error will be written
at the point the function is called.  This function is used internally.
}
\examples{
library(logr)

# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send error message to log
log_error("Here is a error")

# Close log
log_close()

# View results
writeLines(readLines(lf))

}
\seealso{
\code{\link{log_warning}} to write a warning message to the log.
}
