% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{lol.sims.fat_tails}
\alias{lol.sims.fat_tails}
\title{Fat Tails Simulation}
\usage{
lol.sims.fat_tails(
  n,
  d,
  rotate = FALSE,
  f = 15,
  s0 = 10,
  rho = 0.2,
  t = 0.8,
  priors = NULL
)
}
\arguments{
\item{n}{the number of samples of the simulated data.}

\item{d}{the dimensionality of the simulated data.}

\item{rotate}{whether to apply a random rotation to the mean and covariance. With random rotataion matrix \code{Q}, \code{mu = Q*mu}, and \code{S = Q*S*Q}. Defaults to \code{FALSE}.}

\item{f}{the fatness scaling of the tail. S2 = f*S1, where S1_{ij} = rho if i != j, and 1 if i == j. Defaults to \code{15}.}

\item{s0}{the number of dimensions with a difference in the means. s0 should be < d. Defaults to \code{10}.}

\item{rho}{the scaling of the off-diagonal covariance terms, should be < 1. Defaults to \code{0.2}.}

\item{t}{the fraction of each class from the narrower-tailed distribution. Defaults to \code{0.8}.}

\item{priors}{the priors for each class. If \code{NULL}, class priors are all equal. If not null, should be \code{|priors| = K}, a length \code{K} vector for \code{K} classes. Defaults to \code{NULL}.}
}
\value{
A list of class \code{simulation} with the following:
\item{X}{\code{[n, d]} the \code{n} data points in \code{d} dimensions as a matrix.}
\item{Y}{\code{[n]} the \code{n} labels as an array.}
\item{mus}{\code{[d, K]} the \code{K} class means in \code{d} dimensions.}
\item{Sigmas}{\code{[d, d, K]} the \code{K} class covariance matrices in \code{d} dimensions.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
\item{simtype}{The name of the simulation.}
\item{params}{Any extraneous parameters the simulation was created with.}
}
\description{
A function for simulating from 2 classes with differing means each with 2 sub-clusters, where one sub-cluster has a narrow tail and the other sub-cluster has a fat tail.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("sims", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.fat_tails(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
}
\author{
Eric Bridgeford
}
