% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_state_get}
\alias{l_bind_state_get}
\title{Get the event pattern and callback Tcl code of a state binding}
\usage{
l_bind_state_get(target, id)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{id}{state binding id}
}
\value{
Character vector of length two. First element is the event pattern,
  the second element is the Tcl callback code.
}
\description{
This function returns the registered event pattern and the Tcl
  callback code that the Tcl interpreter evaluates after a event occurs that
  matches the event pattern.
}
\details{
Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\seealso{
\code{\link{l_bind_state}}, \code{\link{l_bind_state_ids}},
  \code{\link{l_bind_state_delete}}, \code{\link{l_bind_state_reorder}}
}
