% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_change.R
\name{percent_change}
\alias{percent_change}
\title{Computes the percent change}
\usage{
percent_change(baseline, followup)
}
\arguments{
\item{baseline, followup}{A numeric vector with data to compute the percent
change.}
}
\value{
A vector of class \code{lvmisc_percent}.
}
\description{
\code{percent_change} returns the element-wise percent change between two
numeric vectors.
}
\examples{
baseline <- sample(20:40, 10)
followup <- baseline * runif(10, min = 0.5, max = 1.5)

percent_change(baseline, followup)
}
\seealso{
\code{\link[=percent]{percent()}},
\code{{\link[=error_pct]{error_pct()}}}
}
