% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_processor.R
\name{AnthropicProcessor}
\alias{AnthropicProcessor}
\title{Anthropic API Processor}
\description{
Anthropic API Processor

Anthropic API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for Anthropic models.
Handles Anthropic-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{mLLMCelltype::BaseAPIProcessor} -> \code{AnthropicProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AnthropicProcessor-new}{\code{AnthropicProcessor$new()}}
\item \href{#method-AnthropicProcessor-get_default_api_url}{\code{AnthropicProcessor$get_default_api_url()}}
\item \href{#method-AnthropicProcessor-make_api_call}{\code{AnthropicProcessor$make_api_call()}}
\item \href{#method-AnthropicProcessor-extract_response_content}{\code{AnthropicProcessor$extract_response_content()}}
\item \href{#method-AnthropicProcessor-clone}{\code{AnthropicProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AnthropicProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-AnthropicProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize Anthropic processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnthropicProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{Optional custom base URL for Anthropic API}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AnthropicProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-AnthropicProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default Anthropic API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnthropicProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Default Anthropic API endpoint URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AnthropicProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-AnthropicProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to Anthropic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnthropicProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chunk_content}}{Content for this chunk}

\item{\code{model}}{Model identifier}

\item{\code{api_key}}{API key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
httr response object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AnthropicProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-AnthropicProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from Anthropic API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnthropicProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{httr response object}

\item{\code{model}}{Model identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Extracted text content
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AnthropicProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AnthropicProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnthropicProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
