% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_dist_matrix.R
\name{sig_dist_matrix}
\alias{sig_dist_matrix}
\title{Compute a matrix of distances / similarities between two sets of signatures.}
\usage{
sig_dist_matrix(x1, x2, method = "cosine")
}
\arguments{
\item{x1}{The first set of signatures (a numerical matrix-like object
in which each column is a signature).}

\item{x2}{The second set of signatures, similar data type to \code{x1},
and must have the same number of rows as \code{x1}.}

\item{method}{As for the \code{\link[philentropy]{distance}} function in package
\code{philenropy}.}
}
\value{
A numeric matrix with dimensions
  \code{ncol(x1)} X \code{ncol(x2)}.
  Each element represents the distance or
  similarity (depending on \code{method})
  between a column in \code{x1} and a column in \code{x2}.
}
\description{
Compute a matrix of distances / similarities between two sets of signatures.
}
\examples{
ex.sigs <- matrix(c(0.2, 0.8, 0.3, 0.7, 0.4, 0.6), nrow = 2)
colnames(ex.sigs) <- c("ex1", "ex2", "ex3")
ref.sigs <- matrix(c(0.21, 0.79, 0.19, 0.81), nrow = 2)
colnames(ref.sigs) <- c("ref1", "ref2")
sig_dist_matrix(ex.sigs, ref.sigs)

}
