% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{as_data_dict_shape}
\alias{as_data_dict_shape}
\title{Validate and coerce any object as a workable data dictionary structure}
\usage{
as_data_dict_shape(object)
}
\arguments{
\item{object}{A potential valid data dictionary to be coerced.}
}
\value{
A list of data frame(s) with \code{madshapR::class} 'data_dict_shape'.
}
\description{
Validates the input object as a workable data dictionary structure and
returns it with the appropriate \code{madshapR::class} attribute. This function
mainly helps validate input within other functions of the package but could
be used to check if a data dictionary is valid for use in a function.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
data_dict <- madshapR_examples$`data_dictionary_example`
data_dict <- as_data_dict_shape(data_dict)
glimpse(data_dict)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
