% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_pivot_wider}
\alias{data_dict_pivot_wider}
\title{Transform column(s) of a data dictionary from long format to wide format}
\usage{
data_dict_pivot_wider(data_dict, taxonomy = NULL)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
transformed.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}
}
\value{
A list of data frame(s) identifying a data dictionary.
}
\description{
Transforms column(s) of a data dictionary from long format to wide format.
If a taxonomy is provided, the corresponding columns in the data
dictionary will be converted to a format with the taxonomy expanded.
This operation is equivalent to performing a \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}} on these
columns following the taxonomy structure provided. Variable names in the
data dictionary must be unique.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
data_dict <- madshapR_examples$`data_dictionary_example`
taxonomy  <- madshapR_examples$`taxonomy_example`
data_dict_longer <- data_dict_pivot_longer(data_dict, taxonomy)
data_dict_wider <- data_dict_pivot_wider(data_dict_longer, taxonomy)

glimpse(data_dict_wider)

}

}
\seealso{
\code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}, \code{\link[=as_data_dict]{as_data_dict()}}
}
