% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km.R
\name{ph_diagplot_lch}
\alias{ph_diagplot_lch}
\title{PH Diagnosis Plot of Log Cumulative Hazard Rate versus time or log-time}
\usage{
ph_diagplot_lch(
  km_fit,
  time_scale,
  log_time = TRUE,
  endpoint_name = "",
  subtitle = "",
  exclude_censor = TRUE
)
}
\arguments{
\item{km_fit}{returned object from \code{survival::survfit}}

\item{time_scale}{a character string, 'years', 'months', 'weeks' or 'days', time unit of median survival time}

\item{log_time}{logical, TRUE (default) or FALSE}

\item{endpoint_name}{a character string, name of the endpoint}

\item{subtitle}{a character string, subtitle of the plot}

\item{exclude_censor}{logical, should censored data point be plotted}
}
\value{
a plot of log cumulative hazard rate
}
\description{
This plot is also known as log negative log survival rate.
}
\details{
a diagnosis plot for proportional hazard assumption, versus log-time (default) or time
}
\examples{
library(survival)
data(adtte_sat)
data(pseudo_ipd_sat)
combined_data <- rbind(adtte_sat[, c("TIME", "EVENT", "ARM")], pseudo_ipd_sat)
kmobj <- survfit(Surv(TIME, EVENT) ~ ARM, combined_data, conf.type = "log-log")
ph_diagplot_lch(kmobj,
  time_scale = "month", log_time = TRUE,
  endpoint_name = "OS", subtitle = "(Before Matching)"
)
}
