% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-helper.R
\name{medSurv_makeup}
\alias{medSurv_makeup}
\title{Helper function to retrieve median survival time from a \code{survival::survfit} object}
\usage{
medSurv_makeup(km_fit, legend = "before matching", time_scale)
}
\arguments{
\item{km_fit}{returned object from \code{survival::survfit}}

\item{legend}{a character string, name used in 'type' column in returned data frame}

\item{time_scale}{a character string, 'years', 'months', 'weeks' or 'days', time unit of median survival time}
}
\value{
a data frame with a index column 'type', median survival time and confidence interval
}
\description{
Extract and display median survival time with confidence interval
}
\examples{
data(adtte_sat)
data(pseudo_ipd_sat)
library(survival)
combined_data <- rbind(adtte_sat[, c("TIME", "EVENT", "ARM")], pseudo_ipd_sat)
kmobj <- survfit(Surv(TIME, EVENT) ~ ARM, combined_data, conf.type = "log-log")

# Derive median survival time
medSurv <- medSurv_makeup(kmobj, legend = "before matching", time_scale = "day")
medSurv
}
