% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{plot_weights_ggplot}
\alias{plot_weights_ggplot}
\title{Plot MAIC weights in a histogram with key statistics in legend using \code{ggplot2}}
\usage{
plot_weights_ggplot(weighted_data, bin_col, vline_col, main_title, bins)
}
\arguments{
\item{weighted_data}{object returned after calculating weights using \link{estimate_weights}}

\item{bin_col}{a string, color for the bins of histogram}

\item{vline_col}{a string, color for the vertical line in the histogram}

\item{main_title}{Name of scaled weights plot and unscaled weights plot, respectively.}

\item{bins}{number of bin parameter to use}
}
\value{
a plot of unscaled and scaled weights
}
\description{
Generates a \code{ggplot} histogram of weights. Default is to plot both unscaled and scaled weights on a same graph.
}
\examples{
if (requireNamespace("ggplot2")) {
  plot_weights_ggplot(weighted_sat,
    bin_col = "#6ECEB2",
    vline_col = "#688CE8",
    main_title = c("Scaled Individual Weights", "Unscaled Individual Weights"),
    bins = 50
  )
}
}
