/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Instance;
import cc.mallet.types.SingleInstanceIterator;
import cc.mallet.util.MalletLogger;
import com.google.errorprone.annotations.Var;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public abstract class Pipe
implements Serializable,
AlphabetCarrying {
    private static Logger logger = MalletLogger.getLogger(Pipe.class.getName());
    Alphabet dataAlphabet = null;
    Alphabet targetAlphabet = null;
    boolean dataAlphabetResolved = false;
    boolean targetAlphabetResolved = false;
    boolean targetProcessing = true;
    UUID instanceId = UUID.randomUUID();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static transient ConcurrentMap<UUID, Object> deserializedEntries = new ConcurrentHashMap<UUID, Object>();

    public Pipe() {
        this(null, null);
    }

    public Pipe(Alphabet dataDict, Alphabet targetDict) {
        this.dataAlphabet = dataDict;
        this.targetAlphabet = targetDict;
    }

    public boolean precondition(Instance inst) {
        return true;
    }

    public Instance pipe(Instance inst) {
        throw new UnsupportedOperationException("Pipes of class " + this.getClass().getName() + " do not guarantee one-to-one mapping of Instances.  Use 'newIteratorFrom' method instead.");
    }

    public Iterator<Instance> newIteratorFrom(Iterator<Instance> source) {
        return new SimplePipeInstanceIterator(source);
    }

    public Instance[] instancesFrom(@Var Iterator<Instance> source) {
        if (!(source = this.newIteratorFrom(source)).hasNext()) {
            return new Instance[0];
        }
        Instance inst = source.next();
        if (!source.hasNext()) {
            return new Instance[]{inst};
        }
        ArrayList<Instance> ret = new ArrayList<Instance>();
        ret.add(inst);
        while (source.hasNext()) {
            ret.add(source.next());
        }
        return (Instance[])ret.toArray();
    }

    public Instance[] instancesFrom(Instance inst) {
        return this.instancesFrom(new SingleInstanceIterator(inst));
    }

    public Instance instanceFrom(Instance inst) {
        Instance[] results = this.instancesFrom(inst);
        if (results.length == 0) {
            return null;
        }
        return results[0];
    }

    public void setTargetProcessing(boolean lookForAndProcessTarget) {
        this.targetProcessing = lookForAndProcessTarget;
    }

    public boolean isTargetProcessing() {
        return this.targetProcessing;
    }

    public Alphabet getDataAlphabet() {
        return this.dataAlphabet;
    }

    public Alphabet getTargetAlphabet() {
        return this.targetAlphabet;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.getDataAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getDataAlphabet(), this.getTargetAlphabet()};
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        Alphabet[] oas = object.getAlphabets();
        return oas.length == 2 && oas[0].equals(this.getDataAlphabet()) && oas[1].equals(this.getTargetAlphabet());
    }

    public void setDataAlphabet(Alphabet dDict) {
        if (this.dataAlphabet != null && this.dataAlphabet.size() > 0) {
            throw new IllegalStateException("Can't set this Pipe's Data  Alphabet; it already has one.");
        }
        this.dataAlphabet = dDict;
    }

    public boolean isDataAlphabetSet() {
        return this.dataAlphabet != null && this.dataAlphabet.size() > 0;
    }

    public void setOrCheckDataAlphabet(Alphabet a) {
        if (this.dataAlphabet == null) {
            this.dataAlphabet = a;
        } else if (!this.dataAlphabet.equals(a)) {
            throw new IllegalStateException("Data alphabets do not match");
        }
    }

    public void setTargetAlphabet(Alphabet tDict) {
        if (this.targetAlphabet != null) {
            throw new IllegalStateException("Can't set this Pipe's Target Alphabet; it already has one.");
        }
        this.targetAlphabet = tDict;
    }

    public void setOrCheckTargetAlphabet(Alphabet a) {
        if (this.targetAlphabet == null) {
            this.targetAlphabet = a;
        } else if (!this.targetAlphabet.equals(a)) {
            throw new IllegalStateException("Target alphabets do not match");
        }
    }

    protected void preceedingPipeDataAlphabetNotification(Alphabet a) {
        if (this.dataAlphabet == null) {
            this.dataAlphabet = a;
        }
    }

    protected void preceedingPipeTargetAlphabetNotification(Alphabet a) {
        if (this.targetAlphabet == null) {
            this.targetAlphabet = a;
        }
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dataAlphabet);
        out.writeObject(this.targetAlphabet);
        out.writeBoolean(this.dataAlphabetResolved);
        out.writeBoolean(this.targetAlphabetResolved);
        out.writeBoolean(this.targetProcessing);
        out.writeObject(this.instanceId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dataAlphabet = (Alphabet)in.readObject();
        this.targetAlphabet = (Alphabet)in.readObject();
        this.dataAlphabetResolved = in.readBoolean();
        this.targetAlphabetResolved = in.readBoolean();
        this.targetProcessing = in.readBoolean();
        this.instanceId = (UUID)in.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        Object prev;
        Object previous = deserializedEntries.get(this.instanceId);
        if (previous != null) {
            return previous;
        }
        if (this.instanceId != null && (prev = deserializedEntries.putIfAbsent(this.instanceId, this)) != null) {
            return prev;
        }
        return this;
    }

    private class SimplePipeInstanceIterator
    implements Iterator<Instance> {
        Iterator<Instance> source;

        public SimplePipeInstanceIterator(Iterator<Instance> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public Instance next() {
            Instance input = this.source.next();
            if (!Pipe.this.precondition(input)) {
                return input;
            }
            return Pipe.this.pipe(input);
        }

        public Pipe getPipe() {
            return null;
        }

        public Iterator<Instance> getSourceIterator() {
            return this.source;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Not supported.");
        }
    }
}

