% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_diff.R
\name{compare_diff}
\alias{compare_diff}
\alias{compare_new}
\title{Compare two datasets for differences}
\usage{
compare_new(.data1, .data2, by = "ID")

compare_diff(
  .data1,
  .data2,
  by = "ID",
  exclude = c("Title", "Coder", "Comments"),
  diff_threshold = 0
)
}
\arguments{
\item{.data1}{First dataset to compare}

\item{.data2}{Second dataset to compare}

\item{by}{Column name to join on (default is "ID")}

\item{exclude}{Character vector of column names to exclude from comparison.
By default, "Title", "Coder", and "Comments" are excluded.}

\item{diff_threshold}{Integer specifying the minimum number of differing
columns for a row to be included in the output.
Default is 0, meaning any difference will be included.
Set to 3 to only show rows with at least 3 differing columns.}
}
\value{
A data frame with the differences found
}
\description{
Compare two datasets for differences
}
\details{
This function uses \code{dplyr::anti_join} to find rows in \code{.data1}
that are not present in \code{.data2}.
If no differences are found, a message is printed and \code{NULL} is returned.
If differences are found, they are returned as a data frame.
}
\examples{
\dontrun{
df1 <- data.frame(ID = 1:5, Value = letters[1:5])
df2 <- data.frame(ID = 3:7, Value = letters[3:7])
compare_new(df1, df2)
compare_new(df1, df1)
}
compare_diff(emperors$Wikipedia, emperors$Britannica)
}
