% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwproj.R
\name{bwproj}
\alias{bwproj}
\title{Bures-Wasserstein Projection}
\usage{
bwproj(means, covs, target_dim = 2, max_iter = 100, verbose = TRUE)
}
\arguments{
\item{means}{an \eqn{(n,p)} matrix of Gaussian means, where \eqn{n} is the number of Gaussians and \eqn{p} is the original dimension.}

\item{covs}{a \eqn{(p,p,n)} array of Gaussian covariance matrices.}

\item{target_dim}{an integer specifying the target lower dimension \eqn{d} (default is 2).}

\item{max_iter}{an integer specifying the maximum number of iterations for the optimization (default is 100).}

\item{verbose}{a logical flag indicating whether to print progress messages (default is TRUE).}
}
\value{
a named list containing \describe{
\item{U}{the \eqn{(p,d)} projection matrix mapping original space to the lower-dimensional space.}
\item{proj_means}{the \eqn{(n,d)} matrix of projected Gaussian means.}
\item{proj_covs}{the \eqn{(d,d,n)} array of projected Gaussian covariance matrices.}
\item{iter_obj}{a vector of objective function values at each iteration.}
\item{iter_gnorm}{a vector of gradient norms at each iteration.}
}
}
\description{
Projects a set of high-dimensional Gaussian distributions specified by their means and covariance matrices 
onto a lower-dimensional subspace using the distance-preserving projection method.
}
