% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapboxer.R
\name{mapboxer}
\alias{mapboxer}
\title{Create a mapboxer widget}
\usage{
mapboxer(source = NULL, style = basemaps$Carto$dark_matter, ...,
  width = NULL, height = NULL, element_id = NULL,
  token = Sys.getenv("MAPBOX_API_TOKEN"))
}
\arguments{
\item{source}{A \link{mapbox_source} that is added to the map with the ID \code{MAPBOXER}.}

\item{style}{The map's Mapbox style.}

\item{...}{The properties of the map, see \url{https://docs.mapbox.com/mapbox-gl-js/api/map/}.}

\item{width}{The width of the widget.}

\item{height}{The height of the widget.}

\item{element_id}{The unique ID of the widget.}

\item{token}{A Mapbox API access token. Only needed if you want to use styles from Mapbox.}
}
\description{
Create a mapboxer widget
}
\examples{
map <- mapboxer(
  center = c(-73.9165, 40.7114),
  zoom = 10,
  minZoom = 6,
  pitch = 30,
  bearing = 45
)

if (interactive()) map
}
