% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{pphase}
\alias{pphase}
\title{Distribution function of PH distribution}
\usage{
pphase(q, ph, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{ph}{An instance of PH distribution.}

\item{lower.tail}{logical; if TRUE, probabilities are P(X <= x), otherwise P(X > x).}

\item{log.p}{logical; if TRUE, probabilities p are returned as log(p).}

\item{...}{Others}
}
\value{
A vector of densities
}
\description{
Compute the cumulative distribution function (c.d.f.) for a given PH distribution
}
\examples{
## create a PH with specific parameters
(phdist <- ph(alpha=c(1,0,0),
              Q=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)),
              xi=c(2,2,0)))

## c.d.f. for 0, 0.1, ..., 1
pphase(q=seq(0, 1, 0.1), ph=phdist)

}
