% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsw.R
\name{global_surface_water_transitions}
\alias{global_surface_water_transitions}
\alias{get_global_surface_water_transitions}
\title{Global Surface Water Transitions}
\source{
\url{https://global-surface-water.appspot.com/}
}
\usage{
get_global_surface_water_transitions(version = "v1_4_2021")
}
\arguments{
\item{version}{A character vector indicating the version of the GSW data set
to make available.}
}
\value{
A character of file paths.
}
\description{
The Global Surface Water dataset was developed by the European Commission's
Joint Research Centre in the framework of the Copernicus Programme. It maps
the location and temporal distribution of water surfaces at the global scale
over the past 3.8 decades and provides statistics on their extent and change.
It is provisioned as a global tiled raster resource available for all land
areas. The reported data represent aggregated observations between 1984 - 2021.
}
\details{
GSW transition data contains information about the type of surface water
change for each pixel. The raster files have integer cell values between
\code{[0, 10]} that code for different transition classes:\tabular{ll}{
   Value \tab Transition Class \cr
   1 \tab Permanent \cr
   2 \tab New Permanent \cr
   3 \tab Lost Permanent \cr
   4 \tab Seasonal \cr
   5 \tab New Seasonal \cr
   6 \tab Lost Seasonal \cr
   7 \tab Seasonal to Permanent \cr
   8 \tab Permanent to Seasonal \cr
   9 \tab Ephemeral Permanent \cr
   10 \tab Ephemeral Seasonal \cr
}
}
\references{
Pekel, JF., Cottam, A., Gorelick, N. et al. High-resolution
mapping of global surface water and its long-term changes. Nature 540,
418–422 (2016). \doi{doi:10.1038/nature20584}
}
\keyword{resource}
