% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_pie_charts.R
\name{add_pie_charts}
\alias{add_pie_charts}
\title{Create Pie Charts}
\usage{
add_pie_charts(
  df,
  admix_columns,
  lat_column,
  lon_column,
  pie_colours,
  border = 0.3,
  border_col = "black",
  opacity = 1,
  pie_size = 1
)
}
\arguments{
\item{df}{data.frame (see examples).}

\item{admix_columns}{the columns of the data.frame containing admixture data.}

\item{lat_column}{string or integer representing the latitude column.}

\item{lon_column}{string or integer representing the longitude column.}

\item{pie_colours}{vector of colours the same length as the number of clusters.}

\item{border}{numeric value of zero or greater.}

\item{border_col}{string denoting colour of pie border.}

\item{opacity}{numeric value of zero to one.}

\item{pie_size}{vector of numeric values of zero or greater. Can be a single value or a vector the same length as the number of sites.}
}
\value{
A list of \code{annotation_custom()} objects.
}
\description{
Internal function used to add pie charts to a ggplot object.
}
\examples{
df <- data.frame(
  site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  lat = c(51.51, 48.85, 52.52, 41.90, 40.42),
  lon = c(-0.12, 2.35, 13.40, 12.49, -3.70),
  Cluster1 = c(0.95, 0.5, 0.1, 0, 0),
  Cluster2 = c(0.05, 0.45, 0.45, 0.01, 0.75),
  Cluster3 = c(0, 0.05, 0.45, 0.99, 0.25)
)

df <- data.frame(
  site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  lat = c(6712008, 6249448, 6894700, 5146012, 4927165),
  lon = c(-13358.34, 261600.80, 1491681.18, 1390380.44, -411882.12),
  Cluster1 = c(0.95, 0.5, 0.1, 0, 0),
  Cluster2 = c(0.05, 0.45, 0.45, 0.01, 0.75),
  Cluster3 = c(0, 0.05, 0.45, 0.99, 0.25)
)

add_pie_charts(df,
  admix_columns = 4:ncol(df),
  lat_column = "lat",
  lon_column = "lon",
  pie_colours = c("blue","purple","green"),
  border = 0.3,
  opacity = 1,
  pie_size = 1
)
}
\keyword{internal}
