% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fizzbuzz.R
\docType{data}
\name{fizzbuzz}
\alias{fizzbuzz}
\alias{fizzbuzz_lazy}
\alias{.fizzbuzz_vector}
\title{Fizz Buzz}
\format{
An object of class \code{character} of length 1000000.
}
\usage{
fizzbuzz(n, show_numbers = TRUE)

fizzbuzz_lazy(n)

.fizzbuzz_vector
}
\arguments{
\item{n}{The number of numbers}

\item{show_numbers}{If \code{TRUE} shows no}
}
\value{
A \code{character} vector of \verb{1, 2, Fizz, 3, Buzz}, etc
}
\description{
For when someone asked you to do something you've done before, you can argue
that the quickest way to do it is to just take the work someone else did and
utilize that.  No reason to reinvent the wheel.
}
\details{
Multiples of \code{3} are shown as \code{"Fizz"}; multiples of \code{5} as \code{"Buzz"};
multiple of both (i.e., \code{15}) are \code{"FizzBuzz"}.
\code{fizzbuzz_lazy()} subsets the \code{.fizzbuzz_vector} object, which is a solution
with default parameters up to \code{1e6}
}
\examples{
fizzbuzz(15)
fizzbuzz(30, show_numbers = FALSE)
cat(fizzbuzz(30), sep = "\n")

\donttest{
# show them how fast your solution is:
if (package_available("bench")) {
  bench::mark(fizzbuzz(1e5), fizzbuzz_lazy(1e5))
}
}
}
\keyword{datasets}
