% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunset.R
\name{sunset}
\alias{sunset}
\title{Sunset time on Mars}
\usage{
sunset(Ls, phi, beta = NULL, gamma_c = NULL, unit = 1)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{beta}{Surface tilt angle [deg]. Optional, for inclined surfaces}

\item{gamma_c}{Surface azimuth angle [deg]. Optional, for inclined surfaces. Zero facing equator, east negative, west positive (-180 to +180)}

\item{unit}{Output unit: 1 for radians, 2 for degrees, 3 for solar hours (default: 1)}
}
\value{
Sunset time [rad], [deg], or [h] depending on unit parameter, or NA during polar night/day
}
\description{
Calculates the sunset time for a horizontal or inclined surface on Mars.
Returns NA during polar night/day periods.
}
