% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{set_poi_conv_minus}
\alias{set_poi_conv_minus}
\title{Set POI sign convention for mass properties list to "-"}
\usage{
set_poi_conv_minus(ds, target, mp)
}
\arguments{
\item{ds}{Ignored.}

\item{target}{Ignored.}

\item{mp}{A mass properties list.}
}
\value{
The mass properties list with the named element \code{poi_conv} set to "-"
}
\description{
\code{set_poi_conv_minus()} sets the products of inertia sign convention for a
mass properties list to "-". This convention determines how products of inertia are
saved to a data set.

The signature of \code{set_poi_conv_minus()} is such that it can be passed as an \code{override} argument
to \code{update_mass_props()} and \code{update_mass_props_and_unc()}, thus ensuring
that calculated POI values are saved using the negative integral convention.
}
\examples{
set_poi_conv_minus(NULL, NULL, get_mass_props(mp_table, "C.1.2.2.3.2.1.1"))

}
