% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rotate}
\alias{rotate}
\alias{rotate.figure}
\title{Rotation rule (Method)}
\usage{
rotate(fig, n, rule, ...)

\method{rotate}{figure}(fig, n = 4, rule = "rotation", ...)
}
\arguments{
\item{fig}{The figure on which the rule is applied}

\item{n}{integer, defines the angle of the rotation. Default is 4, which corresponds to a rotation of \eqn{{4}\alpha}}

\item{rule}{character, defines the rotation rule. Default is counterclockwise. If the  rule arguments contain the string "inv" forces a clockwise rotation. Each corresponds to an \eqn{\alpha=\frac{1}{k}\pi}. Default \eqn{k} is 4. To change the value of \eqn{k} is sufficient to add a number from 1 to 9 in the argument.}

\item{...}{Other arguments}
}
\value{
A figure of class figure with different rotation coordinates

A figure of class figure with different rotation coordinates
}
\description{
Apply a rotation of a fixed angle to a figure
}
\section{Methods (by class)}{
\itemize{
\item \code{rotate(figure)}: Rotate a figure

Apply a rotation of a fixed angle to a figure

}}
\examples{
# default luck
draw(luck())

# apply the default rotation on the default luck
draw(rotate(luck()))

# force clockwise rotation
draw(rotate(luck(), rule = "inv"))
# default luck
draw(luck())

# apply the default rotation on the default luck
draw(rotate(luck()))

# force clockwise rotation
draw(rotate(luck(), rule = "inv"))
}
