% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3Dpotential.R
\name{plot3DPotential}
\alias{plot3DPotential}
\title{graphical visualization of multiple mating potential objects}
\usage{
plot3DPotential(
  matPots,
  subject = NULL,
  density = TRUE,
  sub.ids = NULL,
  N = 3,
  sample = NA,
  text.cex = 0.7,
  pt.cex = 0.7
)
}
\arguments{
\item{matPots}{list, contains one or multiple mating potential objects representing unique potential dimensions}

\item{subject}{character, indicates whether the subject to be visualized is individuals (\code{subject} = 'ind') or all pairwise interactions (\code{subject} = 'pair')}

\item{density}{logical, if TRUE (default), plots probability density over histogram}

\item{sub.ids}{vector, contains the IDs of individuals to be represented in pairwise potential plots}

\item{N}{integer, indicates the number of individuals to sample if sub.ids = 'random' (default N = 3)}

\item{sample}{character, specifies how to sample individuals to be represented in pairwise potential plots. Possible values are "random" (default) or "all". See details.}

\item{text.cex}{specify text expansion factor (text size relative to device default)}

\item{pt.cex}{specify point expansion factor (point size relative to device default)}
}
\value{
No return value, called to draw a plot
}
\description{
Visualize multiple dimensions of mating potential
}
\details{
The individuals to be represented in the pairwise potential plots can either be specified explicitly
through \code{sub.ids}, chosen randomly (\code{sample} = 'random'), or all individuals can be selected (\code{sample} = 'all').
The default is to randomly select 9 individuals. If multiple years are being plotted, the subset is sampled from all years
and the same individuals will be represented in each year, if possible.
}
\examples{
pop <- simulateScene()
sync <- synchrony(pop, "augs")
prox <- proximity(pop, 'maxProp')
compat <- compatibility(pop, 'si_echinacea')
plot3DPotential(list(sync,prox,compat), subject = 'ind')
}
\seealso{
see generic function \code{graphics::\link[graphics]{points}()} for values of \code{pch}
}
\author{
Amy Waananen
}
