% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{rowMinors}
\alias{rowMinors}
\title{Row Minors of A[i,]}
\usage{
rowMinors(A, i)
}
\arguments{
\item{A}{a square matrix}

\item{i}{row index}
}
\value{
a vector of the minors of A[i,]
}
\description{
Returns the vector of minors of row i of the square matrix A
}
\examples{
M <- matrix(c(4, -12, -4,
              2,   1,  3,
             -1,  -3,  2), 3, 3, byrow=TRUE)
minor(M, 1, 1)
minor(M, 1, 2)
minor(M, 1, 3)
rowMinors(M, 1)
}
\seealso{
Other determinants: 
\code{\link{Det}()},
\code{\link{adjoint}()},
\code{\link{cofactor}()},
\code{\link{minor}()},
\code{\link{rowCofactors}()}
}
\author{
Michael Friendly
}
\concept{determinants}
