% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hubert_t.R
\name{prepBoxPlots}
\alias{prepBoxPlots}
\title{Prepare data for box plots}
\usage{
prepBoxPlots(A, groups = NULL, group_list = NULL, absolute = TRUE)
}
\arguments{
\item{A}{Distance or similarity matrix, e.g. correlation}

\item{groups}{CFA model in lavaan syntax. Either \code{groups} or \code{group_list} but not both must be supplied.}

\item{group_list}{List of groupings. Either \code{groups} or \code{group_list} but not both must be supplied.}

\item{absolute}{Use the absolute values of A (defaults to TRUE)}
}
\value{
multi: data frame for making box plots for block-specific tests

overall: data frame for making box plots for overall test
}
\description{
This function prepares the data for making box plots.
}
\examples{
library(matrixStrucTest)
library(ggplot2)

data("big5")

# get column numbers for questionnaire items
items <- grep("[0-9]", colnames(big5))

# compute Spearman's correlation matrix
A <- cor(big5[, items], use = "complete.obs", method = "spearman")

groups <- "extrovert ~ E1 + E2 + E3 + E4 + E5 + E6 + E7 + E8 + E9 + E10
           neurotic ~ N1 + N2 + N3 + N4 + N5 + N6 + N7 + N8 + N9 + N10
           agreeable ~ A1 + A2 + A3 + A4 + A5 + A6 + A7 + A8 + A9 + A10
           conscientious ~ C1 + C2 + C3 + C4 + C5 + C6 + C7 + C8 + C9 + C10
           open ~ O1 + O2 + O3 + O4 + O5 + O6 + O7 + O8 + O9 + O10"

# Make box plots contrasting within and between group correlations
box <- prepBoxPlots(A = A, groups = groups, absolute = TRUE)

ggplot(aes(x = as.factor(delta), y = a), data = box$overall)+
  geom_boxplot()+
  theme_bw(22)+
  labs(x = expression(Delta), y="|a|")

dev.new(width = 12, height = 5)
ggplot(aes(x = as.factor(delta), y = a), data = box$multi)+
  geom_boxplot()+
  facet_grid(~block)+
  theme_bw(22)+
labs(x = expression(Delta), y = "|a|")
}
