## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(maxRgain)

## -----------------------------------------------------------------------------
head(Gouveio)


## ----eval = FALSE-------------------------------------------------------------
#  polyclonal(traits, ref = NULL, clmin = 2, clmax, dmg = NULL,
#             meanvec = NULL, criteria = NULL, data)

## -----------------------------------------------------------------------------
# Named numeric vector with the trait means
mymeanvec <- c(yd = 3.517, pa = 12.760, ta = 4.495, ph = 3.927, bw = 1.653)

# Vector with the traits to be optimized
mytraits <- c("yd", "pa",  "ta", "ph", "bw")

# Named numeric vector with the selection criteria
mycriteria <- c(yd = 1, pa = 1, ta = 1, ph = -1, bw = -1)

# Name of the reference column with the genotype labels
myref = "Clone"


## -----------------------------------------------------------------------------
# dataframe with the desired minimum gains
mydmg <- data.frame(
  lhs = c("yd", "pa", "ta", "ph", "bw"),
  rel = c(">=", ">=", ">=", ">=", ">="),
  rhs = c(20, 3, 3, 1, 2)
  )

## -----------------------------------------------------------------------------
mydmg


## -----------------------------------------------------------------------------
# Using polyclonal() function
with_dmg <- polyclonal(
  traits = mytraits,
  clmin = 7,
  clmax = 20,
  dmg = mydmg,
  meanvec = mymeanvec,
  criteria = mycriteria,
  data = Gouveio
  )

## -----------------------------------------------------------------------------
# Results
with_dmg

## -----------------------------------------------------------------------------
# Summary results
summary(with_dmg)

## -----------------------------------------------------------------------------

# Named numeric vector with the trait means
mymeanvec <- c(yd = 3.517, pa = 12.760, ta = 4.495, ph = 3.927, bw = 1.653)

# Vector with the traits to be optimized
mytraits <- c("yd", "pa","ta", "ph", "bw")

# Named numeric vector with the selection criteria
mycriteria <- c(yd = 1, pa = 1, ta = 1, ph = -1, bw = -1)


base_sit <- polyclonal(
  traits = mytraits,
  clmin = 7,
  clmax = 12,
  dmg = "base",
  meanvec = mymeanvec,
  criteria = mycriteria,
  data = Gouveio
  )


## -----------------------------------------------------------------------------

base_sit


## -----------------------------------------------------------------------------

summary(base_sit)


## ----eval = FALSE-------------------------------------------------------------
#  rmaxp(traits, ref = NULL, clmin = 2 , clmax, meanvec = NULL, criteria = NULL, data)

## -----------------------------------------------------------------------------
# Named numeric vector with the trait means
mymeanvec <- c(yd = 3.517, pa = 12.760)

# Vector with the traits to be optimized
mytraits <- c("yd", "pa")

## -----------------------------------------------------------------------------
# Using rmaxp()
max_pos_gain <- rmaxp(
  traits = mytraits,
  clmin = 9, 
  clmax = 20,
  meanvec = mymeanvec,
  data = Gouveio
  )

# Results
max_pos_gain

## ----eval=FALSE---------------------------------------------------------------
#  rmaxa(traits, ref = NULL, clmin = 2, clmax, constraints = NULL, meanvec = NULL, criteria = NULL, data)
#  

## -----------------------------------------------------------------------------
# Named numeric vector with the trait means
mymeanvec <- c(yd = 3.517, pa = 12.760, ta = 4.495, ph = 3.927, bw = 1.653)

# Vector with the traits to be optimized
mytraits <- c("yd", "pa")

# Named numeric vector with the selection criteria
mycriteria <- c(yd = 1, pa = 1, ta = 1, ph = -1, bw = -1)

## -----------------------------------------------------------------------------
# Using rmaxa()
max_adm_gain <- rmaxa(
  traits = mytraits,
  clmin = 12,
  clmax = 20,
  meanvec = mymeanvec,
  data = Gouveio
  )

# Results
max_adm_gain

