% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{update.polyresult}
\alias{update.polyresult}
\title{Update method for polyclonal results}
\usage{
\method{update}{polyresult}(object, ...)
}
\arguments{
\item{object}{A \code{polyresult} object returned by \code{polyclonal()}.}

\item{...}{Arguments to update in the original \code{polyclonal()} call.}
}
\value{
A new \code{polyresult} object with updated arguments applied.
}
\description{
Allows updating any argument of a previous \code{polyclonal()} call without rewriting the full call.
Defaults are preserved for arguments not provided.
}
\examples{
#' Original call

selections <- polyclonal(traits = c("yd", "pa", "ta", "ph", "bw"),
                  clmin = 7, clmax = 15,
                  dmg = "base",
                  meanvec = c(yd = 3.517, pa = 12.760, ta = 4.495, ph = 3.927, bw = 1.653),
                  criteria = c(yd = 1, pa = 1, ta = 1, ph = -1, bw = -1),
                  data = Gouveio)

selections
# Update clmax
selupdate1 <- update(selections, clmax = 10)

selupdate1

# Update dmg
selupdate2 <- update(selupdate1, dmg = data.frame(
                     lhs = c("yd", "pa", "ta", "ph", "bw"),
                     rel = c(">=", ">=", ">=", ">=", ">="),
                     rhs = c(25, 0, 0, 0, 0)
                     )
                   )

selupdate2

}
