% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-data.R
\name{otsoft_bias_to_df}
\alias{otsoft_bias_to_df}
\title{Converts an OTSoft bias file to a data frame}
\usage{
otsoft_bias_to_df(input, output_path = NA)
}
\arguments{
\item{input}{The path to the input bias file. This should contain more
OT tableaux consisting of mappings between underlying and surface forms with
observed frequency and violation profiles. Constraint violations must be
numeric.

The file should be in OTSoft format. For examples of OTSoft format, see
inst/extdata/sample_bias_file_otsoft.txt.}

\item{output_path}{(optional) A string specifying the path to a file to
which the data frame will be saved in CSV format. If the file exists it
will be overwritten. If this argument isn't provided, the output will not
be written to a file.}
}
\value{
A data frame corresponding to the input OTSoft bias file, containing
the columns
\itemize{
\item \code{Constraint}: The constraint name.
\item \code{Mu}: The mu value for the regularization term.
\item \code{Sigma}: The sigma value for the regularization term.
}
}
\description{
Loads an OTSoft bias file and converts it to the data frame format used by
the maxent.ot functions.
}
\examples{
  # Convert OTSoft bias file to data frame format
  otsoft_file <- system.file(
      "extdata", "sample_bias_file_otsoft.txt", package = "maxent.ot"
  )
  df_output <- otsoft_bias_to_df(otsoft_file)

  # Save data frame to a file
  tmp_output <- tempfile()
  otsoft_bias_to_df(otsoft_file, tmp_output)
}
