% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpm.R
\name{create_tpm}
\alias{create_tpm}
\title{Create a Transition Probability Matrix (TPM)}
\usage{
create_tpm(df)
}
\arguments{
\item{df}{A data frame where the first column is a time indicator (e.g., Year)
and subsequent columns contain numeric values for different entities (e.g., countries).}
}
\value{
A square matrix representing the transition probabilities between entities,
rounded to 4 decimal places.
}
\description{
Create a Transition Probability Matrix (TPM)
}
\examples{
data <- data.frame(
  Year = 2009:2019,
  Country1 = c(136282.02, 182810.3, 252665.95, 170179.0, 227754.5,
               183355.08, 173966.0, 185902.24, 218786.72, 203095.96, 213821.57),
  Country2 = c(1204.78, 2977.8, 241496.85, 139362.9, 40466.0,
               183771.04, 18418.0, 158388.14, 50780.6, 38225.01, 140453.68),
  Country3 = c(61619.92, 46009.64, 54823.95, 57906.1, 60384.0,
               66320.51, 50699.0, 50737.0, 44180.35, 47064.0, 47672.62),
  Country4 = c(63837.63, 71175.86, 76595.18, 70274.68, 59258.64,
               68927.62, 72211.32, 62783.33, 34565.08, 29965.35, 35145.76),
  Country5 = c(8512.95, 11496.78, 32888.2, 22765.61, 23116.0,
               34457.4, 63048.0, 44125.08, 10829.03, 25439.9, 30022.83),
  Country6 = c(3400.56, 19675.75, 38339.7, 4721.01, 2686.8,
               33677.3, 15791.0, 22382.0, 627.0, 895.0, 34082.0),
  Country7 = c(65388.45, 99607.1, 135807.1, 70428.06, 95998.9,
               137877.31, 148593.09, 201386.55, 144250.42, 144501.89, 163244.46)
)

transition_matrix <- create_tpm(data)
transition_matrix
}
