% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuditorFitters.R
\name{SubgroupAuditorFitter}
\alias{SubgroupAuditorFitter}
\title{Static AuditorFitter based on Subgroups}
\value{
\code{\link{AuditorFitter}}\cr

\code{list} with items\cr
\itemize{
\item \code{corr}: pseudo-correlation between residuals and learner prediction.
\item \code{l}: the trained learner.
}
}
\description{
Used to assess multi-calibration based on a list of
binary \code{subgroup_masks} passed during initialization.
}
\examples{
 library("data.table")
 data = data.table(
   "AGE_0_10" =  c(1, 1, 0, 0, 0),
   "AGE_11_20" = c(0, 0, 1, 0, 0),
   "AGE_21_31" = c(0, 0, 0, 1, 1),
   "X1" = runif(5),
   "X2" = runif(5)
 )
 label = c(1,0,0,1,1)
 masks = list(
   "M1" = c(1L, 0L, 1L, 1L, 0L),
   "M2" = c(1L, 0L, 0L, 0L, 1L)
 )
 sg = SubgroupAuditorFitter$new(masks)
}
\seealso{
Other AuditorFitter: 
\code{\link{CVLearnerAuditorFitter}},
\code{\link{LearnerAuditorFitter}},
\code{\link{SubpopAuditorFitter}}
}
\concept{AuditorFitter}
\section{Super class}{
\code{\link[mcboost:AuditorFitter]{mcboost::AuditorFitter}} -> \code{SubgroupAuditorFitter}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{subgroup_masks}}{\code{\link{list}} \cr
List of subgroup masks.
Initialize a SubgroupAuditorFitter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SubgroupAuditorFitter-new}{\code{SubgroupAuditorFitter$new()}}
\item \href{#method-SubgroupAuditorFitter-fit}{\code{SubgroupAuditorFitter$fit()}}
\item \href{#method-SubgroupAuditorFitter-clone}{\code{SubgroupAuditorFitter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mcboost" data-topic="AuditorFitter" data-id="fit_to_resid"><a href='../../mcboost/html/AuditorFitter.html#method-AuditorFitter-fit_to_resid'><code>mcboost::AuditorFitter$fit_to_resid()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SubgroupAuditorFitter-new"></a>}}
\if{latex}{\out{\hypertarget{method-SubgroupAuditorFitter-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \code{\link{SubgroupAuditorFitter}} that
assesses multi-calibration within each group defined
by the `subpops'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SubgroupAuditorFitter$new(subgroup_masks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subgroup_masks}}{\code{\link{list}} \cr
List of subgroup masks. Subgroup masks are list(s) of integer masks,
each with the same length as data to be fitted on.
They allow defining subgroups of the data.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SubgroupAuditorFitter-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SubgroupAuditorFitter-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the learner and compute correlation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SubgroupAuditorFitter$fit(data, resid, mask)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{\link[data.table:data.table]{data.table}}\cr
Features.}

\item{\code{resid}}{\code{\link{numeric}}\cr
Residuals (of same length as data).}

\item{\code{mask}}{\code{\link{integer}}\cr
Mask applied to the data. Only used for \code{SubgroupAuditorFitter}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SubgroupAuditorFitter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SubgroupAuditorFitter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SubgroupAuditorFitter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
