% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{mcc_final_values}
\alias{mcc_final_values}
\title{Get final MCC value for each group}
\usage{
mcc_final_values(x)
}
\arguments{
\item{x}{An \code{mcc} object}
}
\value{
A named numeric vector with final MCC values
}
\description{
Extracts the final (maximum time) MCC value for each group in a grouped
analysis, or the overall final MCC value for ungrouped analyses.
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 1, 2),
  group = c("A", "A", "B", "B", "B", "B", "A", "A")
) |>
  arrange(id, time)

# Ungrouped analysis
mcc_ungrouped <- mcc(df, "id", "time", "cause")
mcc_final_values(mcc_ungrouped)

# Grouped analysis
mcc_grouped <- mcc(df, "id", "time", "cause", by = "group")
mcc_final_values(mcc_grouped)

# Clean up
rm(df, mcc_ungrouped, mcc_grouped)

}
