% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_variance_function.R
\name{mc_variance_function}
\alias{mc_variance_function}
\alias{mc_power}
\alias{mc_binomialP}
\alias{mc_binomialPQ}
\title{Variance Functions for Generalized Linear Models}
\source{
Bonat, W. H. and Jorgensen, B. (2016) Multivariate covariance
generalized linear models. Journal of the Royal Statistical Society:
Series C (Applied Statistics), 65:649--675.
}
\usage{
mc_variance_function(
  mu,
  power,
  Ntrial,
  variance,
  inverse,
  derivative_power,
  derivative_mu
)

mc_power(mu, power, inverse, derivative_power, derivative_mu)

mc_binomialP(mu, power, inverse, Ntrial,
                    derivative_power, derivative_mu)

mc_binomialPQ(mu, power, inverse, Ntrial,
                     derivative_power, derivative_mu)
}
\arguments{
\item{mu}{Numeric vector of expected values. Typically obtained from
\code{\link{mc_link_function}}.}

\item{power}{Numeric value (for \code{power} and \code{binomialP})
or numeric vector of length two (for \code{binomialPQ}) representing
the power parameters of the variance function.}

\item{Ntrial}{Positive integer or numeric. Number of trials for
binomial response variables.}

\item{variance}{Character string specifying the variance function type:
\code{"power"}, \code{"binomialP"}, or \code{"binomialPQ"}.}

\item{inverse}{Logical. If \code{TRUE}, computes the inverse square root
of the variance function.}

\item{derivative_power}{Logical. If \code{TRUE}, computes the derivative
with respect to the power parameter.}

\item{derivative_mu}{Logical. If \code{TRUE}, computes the derivative
with respect to \code{mu}.}
}
\value{
A named list containing one or more of the following elements,
    depending on the combination of logical arguments:
    \describe{
      \item{V_sqrt}{Square root of the variance function.}
      \item{V_inv_sqrt}{Inverse square root of the variance function.}
      \item{D_V_sqrt_power}{Derivative of V_sqrt with respect to the power parameter.}
      \item{D_V_inv_sqrt_power}{Derivative of V_inv_sqrt with respect to the power parameter.}
      \item{D_V_sqrt_mu}{Derivative of V_sqrt with respect to \code{mu}.}
      \item{D_V_inv_sqrt_mu}{Derivative of V_inv_sqrt with respect to \code{mu}.}
    }
}
\description{
Computes the variance function and its derivatives with respect to
regression, dispersion, and power parameters. This function supports
standard power variance functions as well as binomial responses.
Intended primarily for internal use in model fitting.
}
\details{
The function computes the variance function and its derivatives used in
the estimation of generalized linear models for multiple response variables.
For binomial responses, it accounts for the number of trials and supports
both single (\code{binomialP}) and double (\code{binomialPQ}) power specifications.
}
\examples{
x1 <- seq(-1, 1, length.out = 5)
X <- model.matrix(~x1)
mu <- mc_link_function(beta = c(1, 0.5), X = X, offset = NULL, link = "logit")
mc_variance_function(mu = mu$mu, power = c(2, 1), Ntrial = 1,
                     variance = "binomialPQ", inverse = FALSE,
                     derivative_power = TRUE, derivative_mu = TRUE)

}
\seealso{
\code{\link{mc_link_function}}
}
\author{
Wagner Hugo Bonat
}
