% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fnames.R, R/freqlist.R,
%   R/tokenize.R, R/types.R
\name{keep_re}
\alias{keep_re}
\alias{drop_re}
\alias{drop_re.fnames}
\alias{keep_re.fnames}
\alias{drop_re.freqlist}
\alias{keep_re.freqlist}
\alias{drop_re.tokens}
\alias{keep_re.tokens}
\alias{drop_re.types}
\alias{keep_re.types}
\title{Subset an object based on regular expressions}
\usage{
keep_re(x, pattern, perl = TRUE, invert = FALSE, ...)

drop_re(x, pattern, perl = TRUE, ...)

\method{drop_re}{fnames}(x, pattern, perl = TRUE, ...)

\method{keep_re}{fnames}(x, pattern, perl = TRUE, invert = FALSE, ...)

\method{drop_re}{freqlist}(x, pattern, perl = TRUE, ...)

\method{keep_re}{freqlist}(x, pattern, perl = TRUE, invert = FALSE, ...)

\method{drop_re}{tokens}(x, pattern, perl = TRUE, ...)

\method{keep_re}{tokens}(x, pattern, perl = TRUE, invert = FALSE, ...)

\method{drop_re}{types}(x, pattern, perl = TRUE, ...)

\method{keep_re}{types}(x, pattern, perl = TRUE, invert = FALSE, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{pattern}{Either an object of the class \code{\link{re}}
or a character vector of length one containing a regular expression.}

\item{perl}{Logical.
Whether \code{pattern} is treated as a PCRE flavor regular expression.
The \code{perl} argument is only used if \code{pattern} is a regular character vector.
If \code{pattern} is an object of the class \code{\link{re}}, then the
\code{perl} argument is ignored, and the relevant information in the
\code{\link{re}} object \code{pattern}, viz. the value of \code{pattern$perl}, is
used instead.}

\item{invert}{Logical. Whether the matches should be selected rather than the
non-matches.}

\item{...}{Additional arguments.}
}
\value{
Object of the same class as \code{x} with the selected elements only.
}
\description{
These methods can be used to subset objects based on a regular expression.
}
\details{
The methods \code{\link[=keep_pos]{keep_pos()}} and \code{\link[=drop_pos]{drop_pos()}} are part of a family of methods of
the mclm package used to subset different objects. The methods
starting with \code{keep_} extract the items in \code{x} based on the criterion specified
by the second argument. In contrast, the methods starting with \code{drop_} \emph{exclude}
the items that match the criterion in the same argument.

Calling a \code{drop_} method is equivalent to calling its \code{keep_} counterpart when
the \code{invert} argument is \code{TRUE}.
}
\examples{
# For a 'freqlist' object --------------------
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

keep_re(flist, "[ao]")
drop_re(flist, "[ao]")
keep_re(flist, "[ao]", invert = TRUE) # same as drop_re()

# For a 'types' object -----------------------
(tps <- as_types(letters[1:10]))

keep_re(tps, "[acegi]")
drop_re(tps, "[acegi]")

# For a 'tokens' object ----------------------
(tks <- as_tokens(letters[1:10]))

keep_re(tks, "[acegi]")
drop_re(tks, "[acegi]")
}
\seealso{
Other subsetters: 
\code{\link{brackets}},
\code{\link{keep_bool}()},
\code{\link{keep_pos}()},
\code{\link{keep_types}()}
}
\concept{subsetters}
