% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc.R
\name{read_conc}
\alias{read_conc}
\title{Read a concordance from a file}
\usage{
read_conc(
  file,
  sep = "\\t",
  file_encoding = "UTF-8",
  stringsAsFactors = FALSE,
  ...
)
}
\arguments{
\item{file}{Name of the input file.}

\item{sep}{Field separator used in the input file.}

\item{file_encoding}{Encoding of the input file.}

\item{stringsAsFactors}{Logical. Whether character data should automatically
be converted to factors. It applies to all columns except for \code{"source"},
\code{"left"}, \code{"match"} and \code{"right"}, which are never converted.}

\item{...}{Additional arguments, not implemented.}
}
\value{
Object of class \code{\link{conc}}.
}
\description{
This function reads concordance-based data frames that are written to file
with the function \code{\link[=write_conc]{write_conc()}}.
}
\examples{
(d <- conc('A very small corpus.', '\\\\w+', as_text = TRUE))
\dontshow{.old_wd <- setwd(tempdir())}
write_conc(d, "example_data.tab")
(d2 <- read_conc("example_data.tab"))
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=import_conc]{import_conc()}} for reading files not generated with \code{\link[=write_conc]{write_conc()}}.

Other reading functions: 
\code{\link{read_assoc}()},
\code{\link{read_fnames}()},
\code{\link{read_freqlist}()},
\code{\link{read_tokens}()},
\code{\link{read_txt}()},
\code{\link{read_types}()}
}
\concept{reading functions}
