% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R
\name{chk_mcmcr}
\alias{chk_mcmcr}
\alias{chk_mcmcarray}
\alias{chk_mcmcrs}
\title{Check MCMC objects}
\usage{
chk_mcmcarray(x, x_name = NULL)

chk_mcmcr(x, x_name = NULL)

chk_mcmcrs(x, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
\code{NULL}, invisibly. Called for the side effect of throwing an error
if the condition is not met.
}
\description{
Checks class and structure of MCMC objects.

\code{chk_mcmcarray}
checks if \code{\link[=mcmcarray-object]{mcmcarray-object()}} object using

\code{is.array(x) && is.numeric(x)}

\code{chk_mcmcr}
checks if an \code{\link[=mcmcr-object]{mcmcr-object()}}.

\code{chk_mcmcrs}
checks if an \code{\link[=mcmcrs-object]{mcmcrs-object()}}.
}
\details{
To just check class use \code{\link[chk:chk_s3_class]{chk::chk_s3_class()}}.
}
\section{Functions}{
\itemize{
\item \code{chk_mcmcarray()}: Check mcmcarray Object

\item \code{chk_mcmcr()}: Check mcmcr Object

\item \code{chk_mcmcrs()}: Check mcmcrs Object

}}
\examples{

# chk_mcmcarray
try(chk_mcmcarray(1))

# chk_mcmcr
chk_mcmcr(as.mcmcr(list(x = 1)))
try(chk_mcmcr(1))

# chk_mcmcrs
chk_mcmcrs(as.mcmcrs(as.mcmcr(list(x = 1))))
try(chk_mcmcrs(1))
}
\seealso{
\code{\link[=vld_mcmcr]{vld_mcmcr()}}
}
