% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_negbinomial.R
\name{f_negbinomial}
\alias{f_negbinomial}
\title{Specify a negative binomial sampling distribution}
\usage{
f_negbinomial(
  link = "log",
  shape.vec = ~1,
  inv.shape.prior = pr_invchisq(df = 1, scale = 1),
  control = negbin_control()
)
}
\arguments{
\item{link}{the name of a link function. Currently the only allowed link function
for the negative binomial sampling distribution is \code{"log"}.}

\item{shape.vec}{optional formula specification of unequal shape values. The
negative binomial (vector) shape parameter is then equal to this vector of
shape values, multiplied by the scalar shape parameter, whose prior is
specified through \code{inv.shape.prior}.}

\item{inv.shape.prior}{Prior on the (scalar) \emph{reciprocal} shape parameter,
i.e. the overdispersion parameter. Supported prior distributions are
\code{\link{pr_fixed}} with a default value of 1, \code{\link{pr_invchisq}} and
\code{\link{pr_gig}}. The current default is \code{pr_invchisq(df=1, scale=1)}.}

\item{control}{a list with computational options. These options can
be specified using function \code{\link{negbin_control}}.}
}
\value{
A family object.
}
\description{
This function can be used in the \code{family} argument of \code{\link{create_sampler}}
or \code{\link{generate_data}} to specify a negative binomial sampling distribution.
}
\details{
The negative binomial distribution with shape r and probability p
has density
\deqn{p(y|r, p) = {\Gamma(y + r)\over y!\Gamma(r)}(1-p)^r p^y}
with mean \eqn{\mu = E(y|r,p) = {rp\over 1-p}} and variance
\eqn{V(y|r,p) = \mu(1 + \mu/r)}. The second term of the variance
can be interpreted as overdispersion with respect to a Poisson
distribution, which would correspond to the limit \eqn{r \rightarrow \infty}.
So the reciprocal shape \eqn{1/r} is an overdispersion parameter,
which typically is inferred. It is assigned a default prior, which
may be changed through argument \code{inv.shape.prior}.

The only supported link function is \code{"log"}. Strictly speaking
the relation between mean \eqn{\mu} and linear predictor \eqn{\eta} is
\deqn{\log\mu = \log r + \log{p\over 1-p} = \log r + \eta}
This way the likelihood function has the same form as that of logistic
binomial regression, so that a Polya-Gamma data augmentation sampling
algorithm can be employed. Note that the fact that the linear predictor
\eqn{\eta} does not include \eqn{\log r} effectively changes the
interpretation of its intercept.
}
\references{
N. Polson, J.G. Scott and J. Windle (2013).
   Bayesian Inference for Logistic Models Using Polya-Gamma Latent Variables.
   Journal of the American Statistical Association 108(504), 1339-1349.

 M. Zhou and L. Carin (2015).
   Negative Binomial Process Count and Mixture Modeling.
   IEEE Transactions on Pattern Analysis and Machine Intelligence 37(2), 307-320.
}
