% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmodel.R
\name{crossval.regmodel}
\alias{crossval.regmodel}
\title{Cross-validation of a regression model}
\usage{
crossval.regmodel(obj, x, y, cv, cal.fun, pred.fun, cv.scope = "local")
}
\arguments{
\item{obj}{a regression model (object of class \code{regmodel})}

\item{x}{a matrix with x values (predictors from calibration set)}

\item{y}{a matrix with y values (responses from calibration set)}

\item{cv}{number of segments (if cv = 1, full cross-validation will be used)}

\item{cal.fun}{reference to function for model calibration}

\item{pred.fun}{reference to function for getting predicted y-values (see description)}

\item{cv.scope}{scope for center/scale operations inside CV loop: 'global' — using globally computed mean and std
or 'local' — recompute new for each local calibration set.}
}
\value{
object of class \code{plsres} with results of cross-validation

Function `pred.fun` must take four agruments: autoscaled x-values, array with regression
coefficients, vectors for centring and scaling of y-values (if used). The function must
return predicted y-values in original units (unscaled and uncentered).
}
\description{
Does cross-validation of a regression model
}
