% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediate.designs.R
\name{mediate.pd}
\alias{mediate.pd}
\title{Estimating Average Causal Mediation Effects under the Parallel Design}
\usage{
mediate.pd(
  outcome,
  mediator,
  treat,
  manipulated,
  data,
  NINT = TRUE,
  sims = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{outcome}{name of the outcome variable in 'data'.}

\item{mediator}{name of the mediator in 'data'. The variable must be binary 
(factor or numeric 0/1).}

\item{treat}{name of the treatment variable in 'data'. Must be binary (factor
or numeric 0/1).}

\item{manipulated}{name of the binary design indicator in 'data', indicating 
whether observation received mediator manipulation.}

\item{data}{a data frame containing all the above variables.}

\item{NINT}{whether the no interaction assumption is made.}

\item{sims}{number of bootstrap simulations. Only relevant when 'NINT' is 
TRUE.}

\item{conf.level}{level of the returned two-sided confidence intervals. Only 
relevant when 'NINT' is TRUE.}
}
\value{
\code{mediate.pd} returns an object of class "\code{mediate.design}",
  a list that contains the components listed below.
  
  The function \code{summary} (i.e., \code{summary.mediate.design}) can be 
  used to obtain a table of the results.
  
  \item{d0, d1}{ point estimates or bounds for the average causal mediation
  effects under the control and treatment conditions, respectively.} 
  \item{d0.ci, d1.ci}{ confidence intervals for the effects based on the
  nonparametric bootstrap. The confidence level is set at the value specified
  in 'conf.level'. Only exists when 'NINT' is TRUE.} \item{nobs}{ number of
  observations used.} \item{conf.level}{ confidence level used. Only exists
  when 'NINT' is TRUE.} \item{sims}{ number of bootstrap simulations used for
  confidence interval calculation. Only exists when 'NINT' is TRUE.} 
  \item{design}{ indicates the design. "PD.NINT" if no interaction assumed;
  "PD" if interaction allowed.}
}
\description{
'mediate.pd' estimates the average causal mediation effects for the parallel 
design. If a treatment-mediator interaction is allowed then the nonparametric
sharp bounds are calculated. If a treatment-mediator interaction is not 
allowed then the estimates of the (point-identified) effects are computed 
along with bootstrapped confidence intervals.
}
\details{
This function calculates average causal mediation effects (ACME) for
  the parallel design. The design consists of two randomly separated 
  experimental arms, indicated by 'manipulated'. In one the treatment is 
  randomized and the mediator and outcome variables are measured. In the 
  second arm, the treatment is randomized, the mediator is perfectly 
  manipulated and the outcome variable is measured.
  
  Under the parallel design, the ACME is identified when it is assumed that 
  there is no interaction between the treatment and mediator. Without the 
  assumption the nonparametric sharp bounds can be computed. See Imai, 
  Tingley and Yamamoto (2012) for details.
}
\examples{
data(boundsdata)

bound2 <- mediate.pd("out", "med", "ttt", "manip", boundsdata, 
                  NINT = TRUE, sims = 100, conf.level=.95)
summary(bound2)

bound2.1 <- mediate.pd("out", "med", "ttt", "manip", boundsdata, NINT = FALSE)
summary(bound2.1)
}
\references{
Tingley, D., Yamamoto, T., Hirose, K., Imai, K. and Keele, L. 
  (2014). "mediation: R package for Causal Mediation Analysis", Journal of 
  Statistical Software, Vol. 59, No. 5, pp. 1-38.
  
  Imai, K., Tingley, D. and Yamamoto, T. (2012) Experimental Designs for 
  Identifying Causal Mechanisms. Journal of the Royal Statistical Society, 
  Series A (Statistics in Society)"
  
  Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2011). Unpacking the 
  Black Box of Causality: Learning about Causal Mechanisms from Experimental 
  and Observational Studies, American Political Science Review, Vol. 105, No.
  4 (November), pp. 765-789.
  
  Imai, K., Keele, L. and Yamamoto, T. (2010) Identification, Inference, and 
  Sensitivity Analysis for Causal Mediation Effects, Statistical Science,
  Vol. 25, No. 1 (February), pp. 51-71.
  
  Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2009) Causal Mediation 
  Analysis Using R" in Advances in Social Science Research Using R, ed. H. D.
  Vinod New York: Springer.
}
\seealso{
\code{\link{mediate}}, \code{\link{summary.mediate.design}}
}
\author{
Dustin Tingley, Harvard University, 
  \email{dtingley@gov.harvard.edu}; Teppei Yamamoto, Massachusetts Institute
  of Technology, \email{teppei@mit.edu}.
}
