% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-event.R
\name{get_event_rsvps}
\alias{get_event_rsvps}
\title{Get the RSVPs for a specified event}
\usage{
get_event_rsvps(
  id,
  max_results = NULL,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)
}
\arguments{
\item{id}{Required event ID}

\item{max_results}{Maximum number of results to return. If set to NULL,
will return all available results (may take a long time).}

\item{handle_multiples}{Character. How to handle multiple matches. One of
"list" or "first", or "error".
If "list", return a list-column with all matches.
If "first", return only the first match.}

\item{extra_graphql}{A graphql object. Extra objects to return}

\item{asis}{Return the raw API response as-is without processing}

\item{...}{Should be empty. Used for parameter expansion}
}
\value{
A tibble with the RSVPs for the specified event
}
\description{
Get the RSVPs for a specified event
}
\examples{
\dontshow{
vcr::insert_example_cassette("get_event_rsvps", package = "meetupr")
meetupr:::mock_if_no_auth()
}
rsvps <- get_event_rsvps(id = "103349942")
\dontshow{
vcr::eject_cassette()
}
}
