% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_from_proportions.R
\name{CI_from_proportions}
\alias{CI_from_proportions}
\title{Confidence Interval for Proportions}
\usage{
CI_from_proportions(events, n, method = "Clopper-Pearson")
}
\arguments{
\item{events}{number of events}

\item{n}{sample size}

\item{method}{the method ("Clopper-Pearson", "Agresti-Coull", "Wilson") that should be used to calculate the confidence intervals.}
}
\value{
List of confidence interval of proportions if input length > 1. If input length = 1 Lower CI and Upper CI.
}
\description{
Calculates a confidence interval for proportions. For a discussion on the differences between methods to calculate confidence intervals, see the Stack Overflow discussion under References.
This method uses the R package "confintr" to calculate the confidence intervals.
}
\examples{
# CI for 9 events in a sample of 10
CI_from_proportions(9, 10)
}
\references{
\href{https://search.r-project.org/CRAN/refmans/confintr/html/ci_proportion.html}{Confintr Function Description}
\href{https://stats.stackexchange.com/questions/82720/confidence-interval-around-binomial-estimate-of-0-or-1}{Stackoverflow Method Discussion}
}
