% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{SEp_from_TE.p}
\alias{SEp_from_TE.p}
\title{Standard Error from Treatment Effect and p-Value}
\usage{
SEp_from_TE.p(TE, p, two_tailed = TRUE)
}
\arguments{
\item{TE}{reported treatment effect}

\item{p}{reported p-value}

\item{two_tailed}{whether one-tailed or two-tailed statistics should be calculated}
}
\value{
Pooled standard error (e.g. standard error of intervention effect)
}
\description{
Calculates the pooled standard error using the treatment effect and p-value.
To avoid an infinitive return when p-value = 1, the p-value is automatically adjusted to 0.99999
}
\examples{
# TE = 1.5, p = 0.8
SEp_from_TE.p(1.5, 0.8)
}
\references{
Altman D G, Bland J M. How to obtain the confidence interval from a P value BMJ 2011; 343 :d2090 doi:10.1136/bmj.d2090
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_2_obtaining_standard_deviations_from_standard_errors_and.htm}{Cochrane Handbook}
}
