% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{fesminima.fes3d}
\alias{fesminima.fes3d}
\title{Find free energy minima in the fes3d object}
\usage{
\method{fesminima}{fes3d}(inputfes, nbins = 8)
}
\arguments{
\item{inputfes}{fes3d object.}

\item{nbins}{number of bins for each CV (default 8).}
}
\value{
minima object.
}
\description{
`fesminima.fes3d` finds free energy minima on 3D free energy surface.
The surface is divided by a 3D grid and minima are found for each
bin. Next the program determines whether the minimum of a bin is a local
minimum of the whole free energy surface. Free energy minima are labeled
constitutively by capital letters.
}
\examples{
tfes<-fes(acealanme3d, imax=5000)
minima<-fesminima(tfes)
minima
}
