% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.mainFunction.R
\name{metaOpt}
\alias{metaOpt}
\title{metaOpt The main function to execute algorithms for getting optimal solutions}
\usage{
metaOpt(FUN, optimType = "MIN", algorithm = "PSO", numVar, rangeVar,
  control = list(), seed = NULL)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represents the type of optimization.
There are two options for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, referring the minimization problem.
Otherwise, you can use \code{"MAX"} for maximization problem.}

\item{algorithm}{a vector or single string value that represent the algorithm used to
       do optimization. There are currently twenty one implemented algorithm:
\itemize{
\item \code{"PSO"}: Particle Swarm Optimization. See \code{\link{PSO}};
\item \code{"ALO"}: Ant Lion Optimizer. See \code{\link{ALO}};
\item \code{"GWO"}: Grey Wolf Optimizer. See \code{\link{GWO}}
\item \code{"DA"} : Dragonfly Algorithm. See \code{\link{DA}}
\item \code{"FFA"}: Firefly Algorithm. See \code{\link{FFA}}
\item \code{"GA"} : Genetic Algorithm. See \code{\link{GA}}
\item \code{"GOA"}: Grasshopper Optimisation Algorithm. See \code{\link{GOA}}
\item \code{"HS"}: Harmony Search Algorithm. See \code{\link{HS}}
\item \code{"MFO"}: Moth Flame Optimizer. See \code{\link{MFO}}
\item \code{"SCA"}: Sine Cosine Algorithm. See \code{\link{SCA}}
\item \code{"WOA"}: Whale Optimization Algorithm. See \code{\link{WOA}}
\item \code{"CLONALG"}: Clonal Selection Algorithm. See \code{\link{CLONALG}}
\item \code{"DE"}: Differential Evolution Algorithm. See \code{\link{DE}}
\item \code{"SFL"}: Shuffled Frog Leaping Algorithm. See \code{\link{SFL}}
\item \code{"CSO"}: Cat Swarm Optimization Algorithm. See \code{\link{CSO}}
\item \code{"ABC"}: Artificial Bee Colony Algorithm. See \code{\link{ABC}}
\item \code{"KH"}: Krill-Herd Algorithm. See \code{\link{KH}}
\item \code{"CS"}: Cuckoo Search Algorithm. See \code{\link{CS}}
\item \code{"BA"}: Bat Algorithm. See \code{\link{BA}}
\item \code{"GBS"}: Gravitation Based Search Algorithm. See \code{\link{GBS}}
\item \code{"BHO"}: Black Hole Based Optimization Algorithm. See \code{\link{BHO}}
}}

\item{numVar}{a positive integer to determine the number variables.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{control}{a list containing all arguments, depending on the algorithm to use. The following list are
       parameters required for each algorithm.

\itemize{

\item \code{PSO}:

    \code{list(numPopulation, maxIter, Vmax, ci, cg, w)}

\item \code{ALO}:

    \code{list(numPopulation, maxIter)}

\item \code{GWO}:

    \code{list(numPopulation, maxIter)}

\item \code{DA}:

    \code{list(numPopulation, maxIter)}

\item \code{FFA}:

    \code{list(numPopulation, maxIter, B0, gamma, alphaFFA)}

\item \code{GA}:

    \code{list(numPopulation, maxIter, Pm, Pc)}

\item \code{GOA}:

    \code{list(numPopulation, maxIter)}

\item \code{HS}:

    \code{list(numPopulation, maxIter, PAR, HMCR, bandwith)}

\item \code{MFO}:

    \code{list(numPopulation, maxIter)}

\item \code{SCA}:

    \code{list(numPopulation, maxIter)}

\item \code{WOA}:

    \code{list(numPopulation, maxIter)}

\item \code{CLONALG}:

    \code{list(numPopulation, maxIter, selectionSize, multipicationFactor, hypermutationRate)}

\item \code{DE}:

    \code{list(numPopulation, maxIter, scalingVector, crossOverRate, strategy)}

\item \code{SFL}:

    \code{list(numPopulation, maxIter, numMemeplex, frogLeapingIteration)}

\item \code{CSO}:

    \code{list(numPopulation, maxIter, mixtureRatio, tracingConstant, maximumVelocity, smp, srd, cdc, spc)}

\item \code{ABC}:

    \code{list(numPopulation, maxIter, cycleLimit)}

\item \code{KH}:

    \code{list(numPopulation, maxIter, maxMotionInduced, inertiaWeightOfMotionInduced, epsilon, foragingSpeed, inertiaWeightOfForagingSpeed, maxDifussionSpeed, constantSpace, mu)}

 \item \code{CS}:

    \code{list(numPopulation, maxIter, abandonedFraction)}

 \item \code{BA}:

    \code{list(numPopulation, maxIter, maxFrequency, minFrequency, gama, alphaBA)}

 \item \code{GBS}:

    \code{list(numPopulation, maxIter, gravitationalConst, kbest)}

 \item \code{BHO}:

    \code{list(numPopulation, maxIter)}


\bold{Description of the \code{control} Parameters}
\itemize{
\item \code{numPopulation}: a positive integer to determine the number populations.
      The default value is 40.

\item \code{maxIter}: a positive integer to determine the maximum number of iterations.
      The default value is 500.

\item \code{Vmax}: a positive integer to determine the maximum velocity of particle.
      The default value is 2.

\item \code{ci}: a positive integer to determine the individual cognitive.
      The default value is 1.49445.

\item \code{cg}: a positive integer to determine the group cognitive.
      The default value is 1.49445.

\item \code{w}: a positive integer to determine the inertia weight.
      The default value is 0.729.

\item \code{B0}: a positive integer to determine the attractiveness firefly at r=0.
      The default value is 1.

\item \code{gamma}: a positive integer to determine light absorption coefficient.
      The default value is 1.

\item \code{alphaFFA}: a positive integer to determine randomization parameter.
      The default value is 0.2.

\item \code{Pm}: a positive integer to determine mutation probability.
      The default value is 0.1.

\item \code{Pc}: a positive integer to determine crossover probability.
      The default value is 0.8.

\item \code{PAR}: a positive integer to determine Pinch Adjusting Rate.
      The default value is 0.3.

\item \code{HMCR}: a positive integer to determine Harmony Memory Considering Rate.
      The default value is 0.95.

\item \code{bandwith}: a positive integer to determine distance bandwith.
      The default value is 0.05.

\item \code{selectionSize}: a positive integer between 0 and numVar to determine selection size.
      The default value is \code{as.integer(numPopulation/4)}.

\item \code{multipicationFactor}: a positive numeric between 0 and 1 to determine number of clones.
      The default value is 0.5.

\item \code{hypermutationRate}: a positive numeric between 0 and 1 to determine probabilty of variable in
       clone candidate solutions to be mutated, close to 1 probability is high and vice versa.
       The default value is 0.1.

\item \code{scalingVector}: a positive numeric between 0 and 1 to determine scalingVector for mutation operator.
      The default value is 0.8.

\item \code{crossOverRate}: a positive numeric between 0 and 1 to determine crossOver probability.
      The default value is 0.5.

\item \code{strategy}: characters to determine mutation method. They are six methods to choose:
   \itemize{
   \item "classical".
   \item "best 1"
   \item "target to best"
   \item "best 2"
   \item "rand 2"
   \item "rand 2 dir"
   }
   The default value is "best 1".

\item \code{numMemeplex}: a positive integer (as.integer()) between 0 and numVar to
       determine number of memeplex (see details).The default value is \code{as.integer(numPopulation/3)}.

\item \code{frogLeapingIteration}: a positive integer (as.integer()) to determine number
       of iteration for each memeplex. The default value is \code{as.integer(10)}.

\item \code{mixtureRatio}: a positive numeric between 0 and 1 to determine flaging proportion.
       higher mixtureRatio increase number of candidate solutions in seeking mode
       and vice versa. The default value is 0.5.

\item \code{tracingConstant}: a positive numeric between 0 and 1 to determine tracingConstant.
       The default value is 0.1.

\item \code{maximumVelocity}: a positive numeric to determine maximumVelocity while candidate solutions
       in tracing mode performing local search. The default value is 1.

\item \code{smp}: a positive integer to determine number of duplication in genetic operator.
       The default value is \code{as.integer(20)}.

\item \code{srd}: a positive numeric between 0 and 100 to determine mutation length in genetic operator.
       The default value is 20.

\item \code{cdc}: a positive integer between 0 and numVar to determine number of variabel in
       candidate solutions in seeking mode to be mutated during mutation step in
       genetic operator. The default value is \code{as.integer(numVar)}.

\item \code{spc}: a logical. if spc is TRUE smp = smp else smp = smp - 1. The default value is TRUE.

\item \code{cycleLimit}: a positive integer to determine number of times allowed for
       candidate solution to not move. The default value is \code{as.integer(numVar * numPopulation)}.

\item \code{maxMotionInduced}: a positive numeric between 0 and 1 to determine
       maximum motion induced. The default value is 0.01.

\item \code{inertiaWeightOfMotionInduced}: a positive numeric between 0 and 1 to determine
       how much motion induced affect krill (candidate solution) movement. the
       greater the value the greater the affect of motion induced on krill movement.
       The default value is 0.01.

\item \code{epsilon}: a positive numeric between 0 and 1 to determine epsilon constant.
       The default value is 1e-05.

\item \code{foragingSpeed}: a positive numeric between 0 and 1 to determine foraging speed.
       The default value is 0.02

\item \code{inertiaWeightOfForagingSpeed}: a positive numeric between 0 and 1 to determine
       how much foraging speed affect krill (candidate solution) movement. the
       greater the value the greater the affect of foraging speed on krill movement.
       The default value is 0.01.

\item \code{maxDifussionSpeed}: a positive numeric between 0 and 1 to determine maximum
       difussion speed. The default value is 0.01.

\item \code{constantSpace}: a numeric between 0 and 1 to determine how much range affect
       krill movement. The default value is 1.

\item \code{mu}: a numeric between 0 and 1 to determine constant number for mutation operator.
      The default value is 0.1.

\item \code{abandonedFraction}: a positive numeric between 0 and 1 to determine fraction
       of population to be replaced. The default value is 0.5.

\item \code{maxFrequency}: a numeric to determine maximum frequency. The default value is 0.1.

\item \code{minFrequency}: a numeric to determine minimum frequency. The default value is -0.1.

\item \code{gama}: a numeric greater than equal to 1. It use to increase pulse rate. The default value is 1.

\item \code{alphaBA}: a numeric between 0 and 1. It use to decrease loudness. The default value is 0.1.

\item \code{gravitationalConst}: a numeric to determine gravitational constant while
       calculating total force. The default value is \code{max(rangeVar)}.

\item \code{kbest}: a positive numeric between 0 and 1 to determine fraction of population
       with best fitness which will affect every candidate solution in population.
       The default value is 0.1.
}
}}

\item{seed}{a number to determine the seed for RNG.}
}
\value{
\code{List} that contain list of variable, optimum value and execution time.
}
\description{
A main funtion to compute the optimal solution using a selected algorithm.
}
\details{
This function makes accessible all algorithm that are implemented
in this package. All of the algorithm use this function as interface to find
the optimal solution, so users do not need to call other functions.
In order to obtain good results, users need to adjust some parameters such as the
objective function, optimum type, number variable or dimension, number populations,
the maximal number of iterations, lower bound, upper bound, or other algorithm-dependent parameters
which are collected in the control parameter.
}
\examples{
##################################
## Optimizing the sphere function

## Define sphere function as an objective function
sphere <- function(X){
    return(sum(X^2))
}

## Define control variable
control <- list(numPopulation=40, maxIter=100, Vmax=2, ci=1.49445, cg=1.49445, w=0.729)

numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## Define control variable
best.variable <- metaOpt(sphere, optimType="MIN", algorithm="PSO", numVar,
                         rangeVar, control)

}
