% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_exp_duration.R
\name{plotly_exp_duration}
\alias{plotly_exp_duration}
\title{Create an interactive plot for exposure duration}
\usage{
plotly_exp_duration(
  outdata,
  color = NULL,
  display = c("n", "prop"),
  display_total = TRUE,
  plot_type_label =
    c("Comparision of Exposure Duration (> = x days) by Treatment Groups",
    "Comparision of Exposure Duration (> = x days and < y days) by Treatment Groups",
    "Comparision by Exposure Duration (> = x days)"),
  plot_group_label = "Treatment group",
  plot_category_label = "Exposure duration",
  hover_summary_var = c("n", "median", "sd", "se", "median", "min", "max", "q1 to q3",
    "range"),
  width = 1000,
  height = 400
)
}
\arguments{
\item{outdata}{An \code{outdata} object created from \code{prepare_exp_duration()}.
\code{extend_exp_duration()} can also be applied.}

\item{color}{Color for a histogram.}

\item{display}{A character vector of display type.
\code{n} or \code{prop} can be selected.}

\item{display_total}{A logical value to display total.}

\item{plot_type_label}{A character vector of histogram type.
The first element is for the standard histogram.
The second element is for the stacked histogram.
The third element is for the horizontal histogram.}

\item{plot_group_label}{A label for grouping.}

\item{plot_category_label}{A label for category.}

\item{hover_summary_var}{A character vector of statistics to be displayed
on hover label of bar.}

\item{width}{Width of the plot.}

\item{height}{Height of the plot.}
}
\value{
Interactive plot for exposure duration.
}
\description{
Create an interactive plot for exposure duration
}
\examples{
# Only run this example in interactive R sessions
if (interactive()) {
  meta <- meta_sl_exposure_example()
  outdata <- meta |>
    prepare_exp_duration() |>
    extend_exp_duration(
      duration_category_list = list(c(1, NA), c(7, NA), c(28, NA), c(12 * 7, NA), c(24 * 7, NA)),
      duration_category_labels = c(">=1 day", ">=7 days", ">=28 days", ">=12 weeks", ">=24 weeks")
    )

  outdata |> plotly_exp_duration()
}
}
