% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_progress.R
\name{utils_progress}
\alias{utils_progress}
\alias{progress}
\alias{run_progress}
\title{Utilities for text progress bar in the terminal}
\usage{
progress(
  min = 0,
  max = 100,
  leftd = "|",
  rightd = "|",
  char = "=",
  style = 2,
  width = getOption("width"),
  time = Sys.time()
)

run_progress(pb, actual, text = "", digits = 0, sleep = 0)
}
\arguments{
\item{min, max}{Numeric values for the extremes of the progress bar. Must have
\code{min < max}.}

\item{leftd, rightd}{The left and right delimiters for the progress bar.
Defaults to \code{"|"}.}

\item{char}{The character (or character string) to form the progress bar.}

\item{style}{The 'style' of the progress bar. Elapsed time is counted from
calling \code{\link[=progress]{progress()}} up to each call of \code{\link[=run_progress]{run_progress()}}.
\itemize{
\item \code{type = 1}: Shows a progress bar without percentage or elapsed time.
\item \code{type = 2}: The default, shows the progress bar and its percentage.
\item \code{type = 3}: Shows the progress bar and elapsed time.
\item \code{type = 4}: Shows the progress bar, percentage, and elapsed time.
}}

\item{width}{The the width of the progress bar. Defaults to the number of
characters is that which fits into \code{getOption("width")}.}

\item{time}{The system time used to compute the elapsed time from calling
\code{\link[=progress]{progress()}} to each call of \code{\link[=run_progress]{run_progress()}}. Defaults to \code{Sys.time()}.}

\item{pb}{An object created with \code{\link[=progress]{progress()}}}

\item{actual}{The actual value, for example, a loop variable that define the
loop index value.}

\item{text}{An optional character string to be shown at the begining of the
progress bar.}

\item{digits}{The number of significant figures in percentage value. Defaults
to \code{0}.}

\item{sleep}{Suspend execution for a time interval with \code{\link[=Sys.sleep]{Sys.sleep()}} within
\code{\link[=run_progress]{run_progress()}}. Defaults to \code{0}.}
}
\value{
\code{\link[=progress]{progress()}} returns a list of class \code{pb_metan} that contains the set
parameters that will called by \code{\link[=run_progress]{run_progress()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Progress bars are configurable, may include percentage, elapsed time, and
custom text.
\itemize{
\item \code{\link[=progress]{progress()}}: Initiate a custom progress bar of class \code{pb_metan}.
\item \code{\link[=run_progress]{run_progress()}}: Run the progress bar and should be called within a 'for
loop' statement, a \code{\link[=lapply]{lapply()}} family or \code{\link[purrr:map]{purrr::map()}} family of functional
programming tools.
}
}
\examples{
\donttest{

################### A for looping approach ################
pb <-  progress()
for (i in 1:100) {
 run_progress(pb, actual = i, sleep = 0.01)
}

################### An apply family approach ##############
pb <- progress(max = 10)
foo <- function(...){
   run_progress(pb, ...)
   rnorm(100) \%>\%  mean()
 }
(a <- sapply(1:10, FUN = foo, sleep = 0.05))

######## A purrr functional programming approach ##########
foo2 <- function(...){
     run_progress(pb2, ...)
     rnorm(100) \%>\%  mean()
}
pb2 <- progress(max = 10000,
                style = 4,
                leftd = "",
                char = ".",
                rightd = "!")

b <- purrr::map_dbl(1:10000, foo2, text = "Progress bar for sampling")
hist(b)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
