% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecipeCategory.R
\name{RecipeCategory}
\alias{RecipeCategory}
\title{RecipeCategory}
\value{
An object of class \code{RecipeCategory}.
}
\description{
Standardized taxonomy for classifying recipes by domain.
Supports hierarchical categories with parent-child relationships.
}
\section{Methods}{

\describe{
\item{$new(name, description, parent)}{Constructor
for creating a new category}
\item{$is_subcategory_of(ancestor_name)}{Check if
this category is a subcategory of another}
\item{$get_path()}{Get full hierarchical path}
\item{$equals(other)}{Check equality by name}
\item{$to_list()}{Serialize to list for JSON}
\item{$print(...)}{Print category information}
\item{$from_list(lst)}{Class method to reconstruct
from list (see details)}
}
}

\examples{
# Use recipe_category() for the public API:
cat <- recipe_category(
  "economics", "Economic indicators"
)
sub <- recipe_category(
  "labor_market", "Labor market",
  parent = "economics"
)

}
\seealso{
Other tidy-api: 
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Character. Category identifier.}

\item{\code{description}}{Character. Human-readable description.}

\item{\code{parent}}{RecipeCategory or NULL. Parent category for hierarchy.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecipeCategory-new}{\code{RecipeCategory$new()}}
\item \href{#method-RecipeCategory-is_subcategory_of}{\code{RecipeCategory$is_subcategory_of()}}
\item \href{#method-RecipeCategory-get_path}{\code{RecipeCategory$get_path()}}
\item \href{#method-RecipeCategory-equals}{\code{RecipeCategory$equals()}}
\item \href{#method-RecipeCategory-to_list}{\code{RecipeCategory$to_list()}}
\item \href{#method-RecipeCategory-print}{\code{RecipeCategory$print()}}
\item \href{#method-RecipeCategory-from_list}{\code{RecipeCategory$from_list()}}
\item \href{#method-RecipeCategory-clone}{\code{RecipeCategory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-new}{}}}
\subsection{Method \code{new()}}{
Create a new RecipeCategory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$new(name, description, parent = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character. Category identifier (non-empty string).}

\item{\code{description}}{Character. Description of the category.}

\item{\code{parent}}{RecipeCategory or NULL. Parent category.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-is_subcategory_of"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-is_subcategory_of}{}}}
\subsection{Method \code{is_subcategory_of()}}{
Check if this category is a subcategory of another
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$is_subcategory_of(ancestor_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ancestor_name}}{Character. Name of the potential
ancestor category.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-get_path"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-get_path}{}}}
\subsection{Method \code{get_path()}}{
Get full hierarchical path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$get_path()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string with slash-separated path
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-equals"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-equals}{}}}
\subsection{Method \code{equals()}}{
Check equality by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$equals(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{RecipeCategory to compare with.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-to_list}{}}}
\subsection{Method \code{to_list()}}{
Serialize to list for JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-print"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-print}{}}}
\subsection{Method \code{print()}}{
Print category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments (not used)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-from_list}{}}}
\subsection{Method \code{from_list()}}{
Deserialize a RecipeCategory from a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$from_list(lst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lst}}{List with name, description, parent fields, or NULL}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
RecipeCategory object or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecipeCategory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecipeCategory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecipeCategory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
