% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuminyear.R
\name{cuminyear}
\alias{cuminyear}
\title{Accumulated variation in year}
\usage{
cuminyear(data, coldate, colnum, start = 1)
}
\arguments{
\item{data}{a dataframe}

\item{coldate}{number of date column}

\item{colnum}{number of values column}

\item{start}{number of start row}
}
\value{
Return a dataframe.
}
\description{
cuminyear calculates an accumulated variation in year of a index.
 Data must be start in january, use start to set this,
 if you data don't start in january and you need
 use this values, consider complete the previous months with 0.
}
\examples{
v=data.frame(
"Date"=c(seq.Date(as.Date("2018-01-01"),as.Date("2019-12-01"),by='month'))
,"Value"=c(rep(2,6),rep(3,6),rep(1,6),rep(5,6)))
cuminyear(v,coldate=1,colnum=2)

v=data.frame(
"Date"=c(seq.Date(as.Date("2018-06-01"),as.Date("2019-12-01"),by='month'))
,"Value"=c(rep(3,7),rep(1,6),rep(5,6)))

#this case, we can start in january 2019
cuminyear(v,coldate=1,colnum=2,start=8)

#or if we need the previous values i can complete january 2018 to may 2018 with 0.
v1=data.frame(Date=c(seq.Date(as.Date("2018-01-01"),as.Date("2018-05-01"),by='month')),
"Value"=c(rep(0,5)))
v=rbind(v1,v)
cuminyear(v,coldate=1,colnum=2)

}
