% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{sim.cif}
\alias{sim.cif}
\alias{sim.cifs}
\alias{simul.cifs}
\alias{setup.cif}
\alias{subdist}
\alias{simsubdist}
\alias{invsubdist}
\title{Simulation of output from Cumulative incidence regression model}
\usage{
sim.cif(
  cif,
  n,
  data = NULL,
  Z = NULL,
  rr = NULL,
  strata = NULL,
  drawZ = TRUE,
  cens = NULL,
  rrc = NULL,
  cumstart = c(0, 0),
  U = NULL,
  pU = NULL,
  type = NULL,
  extend = NULL,
  ...
)
}
\arguments{
\item{cif}{output form prop.odds.subdist or ccr (cmprsk), can also call invsubdist with 
with cumulative and linear predictor}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed
covariates).}

\item{Z}{to use these covariates for simulation rather than drawing new ones.}

\item{rr}{possible vector of relative risk for cox model.}

\item{strata}{possible vector of strata}

\item{drawZ}{to random sample from Z or not}

\item{cens}{specifies censoring model, if "is.matrix" then uses cumulative
hazard given, if "is.scalar" then uses rate for exponential, and if not
given then takes average rate of in simulated data from cox model.}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{cumstart}{to start cumulatives at time 0 in 0.}

\item{U}{uniforms to use for drawing of timing for cumulative incidence.}

\item{pU}{uniforms to use for drawing event type (F1,F2,1-F1-F2).}

\item{type}{of model logistic,cloglog,rr}

\item{extend}{to extend piecewise constant with constant rate. Default is average rate over time from cumulative (when TRUE), if numeric then uses given rate.}

\item{...}{arguments for simsubdist (for example Uniform variable for realizations)}
}
\description{
Simulates data that looks like fit from fitted cumulative incidence model
}
\examples{
library(mets)
data(bmt)
nsim <- 100

## logit cumulative incidence regression model 
cif <- cifreg(Event(time,cause)~platelet+age,data=bmt,cause=1)
estimate(cif)  
plot(cif,col=1)
simbmt <- sim.cif(cif,nsim,data=bmt)
dtable(simbmt,~status)
scif <- cifreg(Event(time,status)~platelet+age,data=simbmt,cause=1)
estimate(scif)
plot(scif,add=TRUE,col=2)

## Fine-Gray cloglog cumulative incidence regression model 
cif <- cifregFG(Event(time,cause)~strata(tcell)+age,data=bmt,cause=1)
estimate(cif)  
plot(cif,col=1)
simbmt <- sim.cif(cif,nsim,data=bmt)
scif <- cifregFG(Event(time,status)~strata(tcell)+age,data=simbmt,cause=1)
estimate(scif)
plot(scif,add=TRUE,col=2)

################################################################
#  simulating several causes with specific cumulatives 
################################################################
cif1 <-  cifreg(Event(time,cause)~strata(tcell)+age,data=bmt,cause=1)
cif2 <-  cifreg(Event(time,cause)~strata(platelet)+tcell+age,data=bmt,cause=2)
cifss <-  list(cif1,cif2)
simbmt <- sim.cifs(list(cif1,cif2),nsim,data=bmt,extend=0.005)
dtable(simbmt,~status)
scif1 <-  cifreg(Event(time,status)~strata(tcell)+age,data=simbmt,cause=1)
scif2 <-  cifreg(Event(time,status)~strata(platelet)+tcell+age,data=simbmt,cause=2)
cbind(cif1$coef,scif1$coef)   
## can be off due to restriction F1+F2<= 1    
cbind(cif2$coef,scif2$coef)   
    
par(mfrow=c(1,2))   
## Cause 1 follows the model    
plot(cif1); plot(scif1,add=TRUE,col=1:2,lwd=2)
# Cause 2:second cause is modified with restriction to satisfy F1+F2<= 1, so scaled down     
plot(cif2); plot(scif2,add=TRUE,col=1:2,lwd=2)
   
}
\author{
Thomas Scheike
}
\keyword{survival}
