% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penultimate.R
\name{maxstable}
\alias{maxstable}
\title{Transform arguments using max stability}
\usage{
maxstable(pars, m = 1L, inverse = FALSE)
}
\arguments{
\item{pars}{vector of location, scale and shape parameters}

\item{m}{[integer] block size}

\item{inverse}{[logical] whether to compute the parameters for the inverse relationship (defaults to \code{FALSE})}
}
\description{
Given a vector of location, scale and shape parameters,
compute the corresponding parameters for block of size
\code{m} assuming a generalized extreme value distribution.
}
\examples{
maxstable(pars = maxstable(pars = c(1,2,0), m = 10), m = 10, inv = TRUE)
maxstable(pars = maxstable(pars = c(1,2,0.1), m = 5), m = 1/5)
}
